/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;

public class DB2Dialect
extends Dialect {
    public DB2Dialect() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2, "numeric(19, $l)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("absval", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("ceiling", new StandardSQLFunction());
        this.registerFunction("ceil", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.registerFunction("round", new StandardSQLFunction());
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("float", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("hex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("ln", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("soundex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("julian_day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("microsecond", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("midnight_seconds", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("quarter", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("date", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("dayofweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofweek_iso", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("days", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("time", new StandardSQLFunction(Hibernate.TIME));
        this.registerFunction("timestamp", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("timestamp_iso", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("week", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("week_iso", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("double", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("varchar", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("real", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("bigint", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("char", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("integer", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("smallint", new StandardSQLFunction(Hibernate.SHORT));
        this.registerFunction("digits", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("chr", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("ucase", new StandardSQLFunction());
        this.registerFunction("lcase", new StandardSQLFunction());
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "values identity_val_local()";
    }

    public String getIdentityColumnString() {
        return "not null generated by default as identity";
    }

    public String getIdentityInsertString() {
        return "default";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "values nextval for " + sequenceName;
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    private String getRowNumber(String sql) {
        StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && !DB2Dialect.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_,");
        return rownumber.toString();
    }

    public String getLimitString(String sql, boolean hasOffset) {
        int startOfSelect = sql.indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(this.getRowNumber(sql));
        if (DB2Dialect.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(" ) as temp_ where rownumber_ ");
        if (hasOffset) {
            pagingSelect.append("between ?+1 and ?");
        } else {
            pagingSelect.append("<= ?");
        }
        return pagingSelect.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.indexOf("select distinct") >= 0;
    }

    public boolean useMaxForLimit() {
        return true;
    }
}

