/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import org.hsqldb.util.ConnectionDialogCommon;

class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    private Connection mConnection;
    private TextField mDriver;
    private TextField mURL;
    private TextField mUser;
    private TextField mPassword;
    private Label mError;
    private String[][] connTypes;

    public static Connection createConnection(String string, String string2, String string3, String string4) throws Exception {
        Class.forName(string).newInstance();
        return DriverManager.getConnection(string2, string3, string4);
    }

    ConnectionDialog(Frame frame, String string) {
        super(frame, string, true);
    }

    private void create() {
        Panel panel;
        Panel panel2;
        Panel panel3;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLayout(new BorderLayout());
        Panel panel4 = new Panel(new BorderLayout());
        if (dimension.width >= 640) {
            panel3 = new Panel(new GridLayout(6, 1, 10, 10));
            panel2 = new Panel(new GridLayout(6, 1, 10, 10));
            panel = new Panel(new GridLayout(1, 2, 10, 10));
        } else {
            panel3 = new Panel(new GridLayout(6, 1));
            panel2 = new Panel(new GridLayout(6, 1));
            panel = new Panel(new GridLayout(1, 2));
        }
        panel4.add("West", panel3);
        panel4.add("Center", panel2);
        panel4.add("South", panel);
        panel4.add("North", ConnectionDialog.createLabel(""));
        panel4.add("East", ConnectionDialog.createLabel(""));
        panel4.setBackground(SystemColor.control);
        panel2.setBackground(SystemColor.control);
        panel3.setBackground(SystemColor.control);
        panel.setBackground(SystemColor.control);
        panel3.add(ConnectionDialog.createLabel("Type:"));
        Choice choice = new Choice();
        this.connTypes = ConnectionDialogCommon.getTypes();
        int n = 0;
        while (n < this.connTypes.length) {
            choice.add(this.connTypes[n][0]);
            ++n;
        }
        choice.addItemListener(this);
        panel2.add(choice);
        panel3.add(ConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField(this.connTypes[0][1]);
        panel2.add(this.mDriver);
        panel3.add(ConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        panel2.add(this.mURL);
        panel3.add(ConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("sa");
        this.mUser.addActionListener(this);
        panel2.add(this.mUser);
        panel3.add(ConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.addActionListener(this);
        this.mPassword.setEchoChar('*');
        panel2.add(this.mPassword);
        Button button = new Button("Ok");
        button.setActionCommand("ConnectOk");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.setActionCommand("ConnectCancel");
        button.addActionListener(this);
        panel.add(button);
        this.add("East", ConnectionDialog.createLabel(""));
        this.add("West", ConnectionDialog.createLabel(""));
        this.mError = new Label("");
        Panel panel5 = ConnectionDialog.createBorderPanel(this.mError);
        this.add("South", panel5);
        this.add("North", ConnectionDialog.createLabel(""));
        this.add("Center", panel4);
        this.doLayout();
        this.pack();
        Dimension dimension2 = this.getSize();
        if (dimension.width >= 640) {
            ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            ((Component)this).setLocation(0, 0);
            ((Component)this).setSize(dimension);
        }
        this.show();
    }

    public static Connection createConnection(Frame frame, String string) {
        ConnectionDialog connectionDialog = new ConnectionDialog(frame, string);
        connectionDialog.create();
        return connectionDialog.mConnection;
    }

    private static Label createLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    private static Panel createBorderPanel(Component component) {
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new BorderLayout());
        panel.add("Center", component);
        panel.add("North", ConnectionDialog.createLabel(""));
        panel.add("South", ConnectionDialog.createLabel(""));
        panel.add("East", ConnectionDialog.createLabel(""));
        panel.add("West", ConnectionDialog.createLabel(""));
        panel.setBackground(SystemColor.control);
        return panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ConnectOk") || actionEvent.getSource() instanceof TextField) {
            try {
                this.mConnection = ConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                this.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.mError.setText(exception.toString());
            }
        } else if (string.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        while (n < this.connTypes.length) {
            if (string.equals(this.connTypes[n][0])) {
                this.mDriver.setText(this.connTypes[n][1]);
                this.mURL.setText(this.connTypes[n][2]);
            }
            ++n;
        }
    }
}

