/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedAttribute;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.util.StringUtils;

public class MetadataMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler
implements AutodetectCapableMBeanInfoAssembler,
InitializingBean {
    private JmxAttributeSource attributeSource;

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        this.attributeSource = attributeSource;
    }

    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("'attributeSource' is required");
        }
    }

    protected void checkManagedBean(Object managedBean) throws IllegalArgumentException {
        if (AopUtils.isJdkDynamicProxy(managedBean)) {
            throw new IllegalArgumentException("MetadataMBeanInfoAssembler does not support JDK dynamic proxies - export the target beans directly or use CGLIB proxies instead");
        }
    }

    public boolean includeBean(Class beanClass, String beanName) {
        return this.attributeSource.getManagedResource(this.getClassToExpose(beanClass)) != null;
    }

    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.hasManagedAttribute(method);
    }

    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.hasManagedAttribute(method);
    }

    protected boolean includeOperation(Method method, String beanKey) {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            return this.hasManagedAttribute(method);
        }
        return this.hasManagedOperation(method);
    }

    private boolean hasManagedAttribute(Method method) {
        return this.attributeSource.getManagedAttribute(method) != null;
    }

    private boolean hasManagedOperation(Method method) {
        return this.attributeSource.getManagedOperation(method) != null;
    }

    protected String getDescription(Object managedBean, String beanKey) {
        ManagedResource mr = this.attributeSource.getManagedResource(this.getClassToExpose(managedBean));
        return mr != null ? mr.getDescription() : "";
    }

    protected String getAttributeDescription(PropertyDescriptor propertyDescriptor, String beanKey) {
        ManagedAttribute setter;
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        ManagedAttribute getter = readMethod != null ? this.attributeSource.getManagedAttribute(readMethod) : null;
        ManagedAttribute managedAttribute = setter = writeMethod != null ? this.attributeSource.getManagedAttribute(writeMethod) : null;
        if (getter != null && StringUtils.hasText(getter.getDescription())) {
            return getter.getDescription();
        }
        if (setter != null && StringUtils.hasText(setter.getDescription())) {
            return setter.getDescription();
        }
        return propertyDescriptor.getDisplayName();
    }

    protected String getOperationDescription(Method method, String beanKey) {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            ManagedAttribute ma = this.attributeSource.getManagedAttribute(method);
            if (ma != null && StringUtils.hasText(ma.getDescription())) {
                return ma.getDescription();
            }
            return method.getName();
        }
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        if (mo != null && StringUtils.hasText(mo.getDescription())) {
            return mo.getDescription();
        }
        return method.getName();
    }

    protected MBeanParameterInfo[] getOperationParameters(Method method, String beanKey) {
        ManagedOperationParameter[] params = this.attributeSource.getManagedOperationParameters(method);
        if (params == null || params.length == 0) {
            return new MBeanParameterInfo[0];
        }
        MBeanParameterInfo[] parameterInfo = new MBeanParameterInfo[params.length];
        Class<?>[] methodParameters = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            ManagedOperationParameter param = params[i];
            parameterInfo[i] = new MBeanParameterInfo(param.getName(), methodParameters[i].getName(), param.getDescription());
        }
        return parameterInfo;
    }

    protected void populateMBeanDescriptor(Descriptor desc, Object managedBean, String beanKey) {
        ManagedResource mr = this.attributeSource.getManagedResource(this.getClassToExpose(managedBean));
        if (mr == null) {
            throw new InvalidMetadataException("No ManagedResource attribute found for class: " + this.getClassToExpose(managedBean));
        }
        this.applyCurrencyTimeLimit(desc, mr.getCurrencyTimeLimit());
        desc.setField("log", mr.isLog() ? "true" : "false");
        if (mr.getLogFile() != null) {
            desc.setField("logFile", mr.getLogFile());
        }
        desc.setField("persistPolicy", mr.getPersistPolicy());
        desc.setField("persistPeriod", Integer.toString(mr.getPersistPeriod()));
        desc.setField("persistName", mr.getPersistName());
        desc.setField("persistLocation", mr.getPersistLocation());
    }

    protected void populateAttributeDescriptor(Descriptor desc, Method getter, Method setter, String beanKey) {
        ManagedAttribute gma = getter == null ? ManagedAttribute.EMPTY : this.attributeSource.getManagedAttribute(getter);
        ManagedAttribute sma = setter == null ? ManagedAttribute.EMPTY : this.attributeSource.getManagedAttribute(setter);
        this.applyCurrencyTimeLimit(desc, this.resolveIntDescriptor(gma.getCurrencyTimeLimit(), sma.getCurrencyTimeLimit()));
        Object defaultValue = this.resolveObjectDescriptor(gma.getDefaultValue(), sma.getDefaultValue());
        desc.setField("default", defaultValue);
        String persistPolicy = this.resolveStringDescriptor(gma.getPersistPolicy(), sma.getPersistPolicy(), "Never");
        desc.setField("persistPolicy", persistPolicy);
        int persistPeriod = this.resolveIntDescriptor(gma.getPersistPeriod(), sma.getPersistPeriod());
        desc.setField("persistPeriod", Integer.toString(persistPeriod));
    }

    protected void populateOperationDescriptor(Descriptor desc, Method method, String beanKey) {
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        if (mo != null) {
            this.applyCurrencyTimeLimit(desc, mo.getCurrencyTimeLimit());
        }
    }

    private int resolveIntDescriptor(int getter, int setter) {
        if (getter == 0 && setter != 0) {
            return setter;
        }
        if (setter == 0 && getter != 0) {
            return getter;
        }
        return getter >= setter ? getter : setter;
    }

    private Object resolveObjectDescriptor(Object getter, Object setter) {
        if (getter != null) {
            return getter;
        }
        if (setter != null) {
            return setter;
        }
        return null;
    }

    private String resolveStringDescriptor(String getter, String setter, String defaultValue) {
        if (getter != null && !defaultValue.equals(getter)) {
            return getter;
        }
        if (setter != null) {
            return setter;
        }
        return null;
    }
}

