/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.Date;
import org.springframework.transaction.TransactionTimedOutException;

public abstract class ResourceHolderSupport {
    private boolean synchronizedWithTransaction;
    private boolean rollbackOnly;
    private Date deadline;
    private int referenceCount = 0;

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
        this.synchronizedWithTransaction = synchronizedWithTransaction;
    }

    public boolean isSynchronizedWithTransaction() {
        return this.synchronizedWithTransaction;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setTimeoutInSeconds(int seconds) {
        this.setTimeoutInMillis(seconds * 1000);
    }

    public void setTimeoutInMillis(long millis) {
        this.deadline = new Date(System.currentTimeMillis() + millis);
    }

    public boolean hasTimeout() {
        return this.deadline != null;
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public int getTimeToLiveInSeconds() {
        double diff = (double)this.getTimeToLiveInMillis() / 1000.0;
        int secs = (int)Math.ceil(diff);
        this.checkTransactionTimeout(secs <= 0);
        return secs;
    }

    public long getTimeToLiveInMillis() throws TransactionTimedOutException {
        if (this.deadline == null) {
            throw new IllegalStateException("No timeout specified for this resource holder");
        }
        long timeToLive = this.deadline.getTime() - System.currentTimeMillis();
        this.checkTransactionTimeout(timeToLive <= 0L);
        return timeToLive;
    }

    private void checkTransactionTimeout(boolean deadlineReached) throws TransactionTimedOutException {
        if (deadlineReached) {
            this.setRollbackOnly();
            throw new TransactionTimedOutException("Transaction timed out: deadline was " + this.deadline);
        }
    }

    public void requested() {
        ++this.referenceCount;
    }

    public void released() {
        --this.referenceCount;
    }

    public boolean isOpen() {
        return this.referenceCount > 0;
    }

    public void clear() {
        this.synchronizedWithTransaction = false;
        this.rollbackOnly = false;
        this.deadline = null;
        this.referenceCount = 0;
    }
}

